// Copyright (c) 2022 - 2023 Asadeus Studios LLC.  All rights reserved.

/**
	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
	THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE DISCLAMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
	BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION).  HOWEVER, CAUSED AND ON ANY THEORY OF LIABILITY, WHEATHER IN CONTRACT, STRICT
	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
*/

#pragma once

#ifndef _ADV_PNMS_H_
#define _ADV_PNMS_H_

#include <CoreMinimal.h>
#include <Engine/Engine.h>
#include <Runtime/Engine/Public/Net/UnrealNetwork.h>
#include <Runtime/Engine/Public/VisualLogger/VisualLogger.h>
#include <Runtime/CoreUObject/Public/UObject/UObjectBaseUtility.h>

// Version Tracking
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define ADV_PNMS_DEVELOPMENT_VERSION 1			// Public version 1.0

// General Version Info
#define ADV_PNMS_VERSION "1.0.0.1.20230815.5.2"
#define ADV_PNMS_MAJOR_VERSION 1
#define ADV_PNMS_MINOR_VERSION 0
#define ADV_PNMS_PATCH_VERSION 0
#define ADV_PNMS_RELEASE_VERSION 20230815
#define ADV_PNMS_ENGINE_MAJOR 5
#define ADV_PNMS_ENGINE_MINOR 2

// MACROS
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef ADV_PNMS_DEBUG
#define ADV_PNMS_DEBUG 0
#endif

// LOGS
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DECLARE_LOG_CATEGORY_EXTERN( LogAdvancedMoungingSystem, Log, All );

// INTERFACES
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Used to implement the interface function ImplementsInterface function in one easy step
#ifndef IMPLEMENT_INTERFACE
#define IMPLEMENT_INTERFACE(uClassName) public: static bool ImplementsInterface(const UObject * object) { return IsValid(object) && object->Implements<uClassName>(); } 
#endif

// Enum Helper
///////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef __ENUM_UTILITY__
#define __ENUM_UTILITY__

// Define C++ helper functions for an Enum to easily perform enum functions
#define DEFINE_ENUM_UTILITY_WITH_MAX(EnumTypeName, MaxName, DefaultValue) \
namespace EnumTypeName##Utility { \
	static FString ToString(EnumTypeName enumValue) \
	{\
		FString outStringName;\
		UEnum::GetValueAsString<EnumTypeName>(enumValue, outStringName);\
		return outStringName;\
	}\
	\
	static EnumTypeName FromString(const FString & enumString) \
	{\
		return (EnumTypeName)UEnum::LookupEnumName(FName("/Script/AdsMountingSystem"), FName(*enumString));\
	}\
	\
	static bool IsValidInt(uint8 intValue)\
	{\
		return intValue >= 0 && intValue <= (uint8)EnumTypeName::MaxName;\
	}\
	\
	static EnumTypeName FromInt(uint8 intValue)\
	{\
		if(EnumTypeName##Utility::IsValidInt(intValue))\
		{\
			return (EnumTypeName)intValue;\
		}\
		\
		return EnumTypeName::DefaultValue;\
	}\
	static FString ToStringFromInt(uint8 value) \
	{ \
		if(EnumTypeName##Utility::IsValidInt(value)) \
		{ \
			EnumTypeName enumValue = static_cast<EnumTypeName>(value); \
			return EnumTypeName##Utility::ToString(enumValue); \
		} \
		\
		return FString(TEXT("Unrecognized")); \
	} \
}

#endif // __ENUM_UTILITY__


// LOG TRACES
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// These are some highly useful MACROS for logging and tracing.

// Log Traces modified for UE5 with the aid of: https://github.com/Cvtx/ue5-log-macros/blob/master/LogMacros.h

// This will define what NETMODE the current trace is in.
#ifndef __NETMODE_WORLD__
#define __NETMODE_WORLD__ (((GetWorld() == nullptr)) ? TEXT("") \
        : (GEngine->GetNetMode(GetWorld()) == NM_Client) ? TEXT("[Client]") \
        : (GEngine->GetNetMode(GetWorld()) == NM_ListenServer) ? TEXT("[ListenServer]") \
        : (GEngine->GetNetMode(GetWorld()) == NM_DedicatedServer) ? TEXT("[DedicatedServer]") \
        : TEXT("[Standalone]"))
#endif // __NETMODE_WORLD__

#ifndef __FUNCTION_NAME__
#	if defined _MSC_VER
#		define __FUNCTION_NAME__    *FString(__FUNCTION__) // this should work for all non-mac build systemns
#	else // Mac Function Name?
#		define __FUNCTION_NAME__    *FString(__func__) // this in theory should work on mac builds gcc compilers
#	endif
#endif // __FUNCTION_NAME__

// Core Log definitions
#ifndef __ADS_LOGS__
#define __ADS_LOGS__

#define ADS_LOG(CategoryName, Verbosity, Message, ...) UE_LOG(CategoryName, Verbosity, TEXT("%s"), *FString::Printf(TEXT(Message), ##__VA_ARGS__) )
#define ADS_OBJ_LOG(CategoryName, Verbosity, Message, ...) UE_LOG(CategoryName, Verbosity, TEXT("%s %s : %s"), *FString(__NETMODE_WORLD__), *FString(__FUNCTION_NAME__), *FString::Printf(TEXT(Message), ##__VA_ARGS__) )

#endif // __ADS_LOGS__

#ifndef __ADV_PNCS_LOGS__
#define __ADV_PNCS_LOGS__

// Plugin Logs
#define LOG_ADV_PNMS_VERBOSE(Format, ...) ADS_OBJ_LOG(LogAdvancedMoungingSystem, Verbose, Format, ##__VA_ARGS__)
#define LOG_ADV_PNMS(Format, ...) ADS_OBJ_LOG(LogAdvancedMoungingSystem, Log, Format, ##__VA_ARGS__)
#define LOG_ADV_PNMS_WARN(Format, ...) ADS_OBJ_LOG(LogAdvancedMoungingSystem, Warning, Format, ##__VA_ARGS__)
#define LOG_ADV_PNMS_ERROR(Format, ...) ADS_OBJ_LOG(LogAdvancedMoungingSystem, Error, Format, ##__VA_ARGS__)

#endif // __ADV_PNCS_LOGS__

#endif	// _ADV_PNMS_H_
