// // Copyright (c) 2022 - 2023 Asadeus Studios LLC.  All rights reserv

#include "Data/AmsMountingAnimationData.h"
#include "Runtime/Engine/Classes/Animation/AnimMontage.h"

/**
* Find the AnimMontage for mounting based on the mount type, the mounting direction
* @param mountType - type of mount being used
* @param mountingDirection - direction that the mounting is occuring
* @return UAnimMontage to play the animation.
*/
class UAnimMontage * UAmsMountingAnimationData::GetMontageForMounting(EAmsMountTypes const mountType, EMountingDirection const mountingDirection) const
{
	for(FAmsMountAnimationData const & animData : this->mountingAnimationData)
	{
		if((mountingDirection == EMountingDirection::MountAnySide || animData.RelativeDirection == mountingDirection) && animData.MountType == mountType)
		{
			return animData.Montage;
		}
	}

	return nullptr;
}

/**
* Find the AnimMontage for dismounting based on the mount type, the mounting direction
* @param mountType - type of mount being used
* @param mountingDirection - direction that the mounting is occurring
* @return UAnimMontage to play the animation.
*/
class UAnimMontage * UAmsMountingAnimationData::GetMontageForDismounting(EAmsMountTypes const mountType, EMountingDirection const dismountingDirection) const
{
	for(FAmsMountAnimationData const & animData : this->dismountingAnimationData)
	{
		if(animData.MountType == mountType && animData.RelativeDirection == dismountingDirection)
		{
			return animData.Montage;
		}
	}

	return nullptr;
}

/**
* Find the AnimMontage for changing seats based on the starting position and the ending position
* @param mountType - type of mount being used
* @param startingSeatName - name of the seat to start the change from
* @param destinationSeatName - name of the seat to end the change seat at.
*/
class UAnimMontage * UAmsMountingAnimationData::GetMontageForChangingSeats(EAmsMountTypes const mountType, FName const & startingSeatName, FName const & destinationSeatName) const
{
	for(FAmsChangeSeatAnimationData const & animData : this->changeSeatAnimationData)
	{
		if(animData.MountType == mountType && animData.StartingSeatName == startingSeatName && animData.DestinationSeatName == destinationSeatName)
		{
			return animData.Montage;
		}
	}

	return nullptr;
}

/**
* Find the AnimMontage for changing seats based on the starting position and the ending position
* @param mountType - type of mount being used
* @param startingSeatId - name of the seat to start the change from
* @param destinationSeatId - name of the seat to end the change seat at.
*/
class UAnimMontage * UAmsMountingAnimationData::GetMontageForChangingSeatsById(EAmsMountTypes const mountType, int32 const & startingSeatId, int32 const & destinationSeatId) const
{
	for(FAmsChangeSeatAnimationData const & animData : this->changeSeatAnimationData)
	{
		if(animData.MountType == mountType && animData.StartingSeatId == startingSeatId && animData.DestinationSeatId == destinationSeatId)
		{
			return animData.Montage;
		}
	}

	return nullptr;
}
